
/**
 ** HyperNewt Newt Soup Definitions
 ** ------------------------------------
 ** Contains the soup definitions and constants for the HyperSoup
 ** which is an enhancement to the built-in Notes soup.
 **
 **/

DefConst('kDefaultStationeryFrame,
	{
		class: 'paperroll,
		height: 224,
		
		timeStamp: nil,
		title: nil,
		viewStationery: nil,
	});

DefConst('kNotesSoup,
	{	
		_proto: newtSoup,
		soupName: ROM_paperRollSoupName,
		soupIndices: [
			{	structure: 'multislot, path: [[ pathExpr: kAppSymbol, 'parentID ], 'timeStamp], type: ['symbol, 'int ] },
			{	structure: 'multiSlot, path: [[ pathExpr: kAppSymbol, 'parentID ], 'title], type: ['symbol, 'string ] },
			{	structure: 'multiSlot, path: [[ pathExpr: kAppSymbol, 'parentID ], 'class], type: ['symbol, 'symbol ] },
		],

		soupQuery: { type: 'index, indexPath: [[ pathExpr: kAppSymbol, 'parentID ], 'timeStamp ], indexValidTest: func(arr) arr[0] = kRootID },
		soupDescr: "The Notepad soup",

		CreateBlankEntry: func() begin
			local app := call kGetCorrectAppFunc with ();
			local parentID := app:DirectoryInfo('directoryID);		
			local newEntry := Clone(kDefaultStationeryFrame);

			newEntry.timeStamp := Time();
			newEntry.title := "";
			newEntry.labels := if app.labelsFilter = '_all then nil else Clone(app.labelsFilter);
			newEntry.(kAppSymbol).parentID := if parentID then parentID else kRootID;
			
			return newEntry;
		end,
	}
);


/**
 ** HyperNewt Directory Soup Definitions
 ** ------------------------------------
 ** Contains the soup definitions and constants for the HyperNewt Directory Soup,
 ** which contains all the directories used in the HyperNewt hierarchy.
 **
 **/
 

	// HyperNewt Directory Soup Constants

constant kHNDirectorySoupName := "Hyper Newt Indexes";

DefConst('kDefaultDirectoryFrame, 
	{
		class: kDirectoryDataSymbol,

		parentID: nil,
		directoryID: nil,
		
		sorter: 'timeStamp,
		
		title: nil,
		timestamp: nil,
		viewStationery: nil,
	});
	
	
/* kHyperIndexSoupDef
 * ------------------
 * Soup definition for the union soup that will contain all of the
 * directories. We index the entries on the slot 'directoryID and
 * the multiSlot, [ 'parentID, 'title ].
 *
 */

DefConst('kHyperIndexSoupDef,
	{	name: kHNDirectorySoupName,
		userName: "HN Directories",
		ownerApp: kAppSymbol,
		ownerAppName: kAppName,
		userDescr: "This soup is used by" && kAppName,

		indexes:	[
						{	structure: 'slot, path: 'directoryID, type: 'symbol },
						{	structure: 'multiSlot, path: ['parentID, 'title], type: ['symbol, 'string] },
					],
  }
);
